//
//  SFNTWriterData.h
//  GSFontTools
//
//  Created by Georg Seifert on 11.12.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import "SFNTWriter.h"
#import <Cocoa/Cocoa.h>

@interface SFNTWriterData : NSObject <SFNTWriter> {
	NSMutableData *_data;
	NSUInteger _numTables;
	NSString *_sfntVersion;
	int _searchRange;
	int _entrySelector;
	int _rangeShift;
	int _nextTableOffset;
	NSMutableDictionary *_tables;
}

@property (readonly, nonatomic) NSData *data;

- (id)initWithtableCount:(int)numTables;
- (void)setData:(NSData *)data forKey:(id)tag;
//- (void)calcMasterChecksum:(NSData *)directory;
- (void)setSfntVersion:(NSString *)sfntVersion;
- (void)close;
@end
